*!! BLIND - Unique Programs
*!! Create descriptives that all programs have in common
*!! Written by Brian Fitzpatrick (bfitzpatrick@gibsonconsult.com)
/*
preamble, f(BLIND\2024-2025\unique_programs)  log(06_common_desc) 
set scheme cleanplots
global sp `"C:\Users\BrianFitzpatrick\OneDrive - GIBSON\Documents\BLIND\Unique Programs FY25\05_da\Admin Data Analysis"'
*/
preamble, f(fulton_county\2024-2025\unique_programs)  log(06_common_desc) 
set scheme cleanplots
global sp `"C:\Users\BrianFitzpatrick\OneDrive - GIBSON\Documents\Fulton County Schools\Unique Programs FY25\05_da\Admin Data Analysis"'

global graph svg //png pdf

*BLIND color scheme (can't use - using one created by Copilot instead)
global c1 115 160 210
global c2 140 190 150
global c3 210 180 150
global c4 190 140 150
global c5 160 150 190

*sections 
global avail 1
global comp1 0
global comp2 1
global change 1

*participation variable macros 
global part1 part_ap lag_gpk lead_pci part_ap part_ib part_avid part_dli part_cca part_de ib_school
global part2 part_ap lag_gpk lead_pci part_ap part_ib part_avid part_dli part_cca part_de 
global part3 part_ap lag_gpk part_ap part_ib part_avid part_dli part_cca part_de 

******************************Program Availability******************************
******************************Program Availability******************************
******************************Program Availability******************************
*!BF Note 7/30/2025: This analysis output not included to preserve anonymity
if $avail == 1 {
	
	use `"${final}/up_common_24"', clear	
	fre zone
	drop if zone=="Virtual Schools"
	foreach v of varlist _all {
		local l`v' `:var lab `v''
	}	
	collapse (mean) $part1 , by(z)
	foreach v of varlist _all {
		la var `v' `"`l`v''"' 
	}	
		
	foreach v in $part1 {
		*bar labels
		gen ml=`v'*100
		replace ml=round(ml, 1)
		gen mls=string(ml)
		replace mls= mls + "%"
		*y labels
		qui sum ml //get the size of the tallest bar
		local max 100 //start at 100
		foreach m in 75 50 25 20 15 10 5 1 { //y-axis length options
			*is the tallest bar taller than each number in the list?
			if `r(max)'<=`m' local max `m' 
		}
		local yl 
		forval i=0(`=`max'/5')`max' { //make 6 even labels 
			local yl `yl' `i' "`i'%" //add %s
		}
		
		twoway bar ml z, bcolor("${c1}") mlab(mls) mlabcolor(black) title(`:var lab `v'') ytitle("Student Participation Rate in Each Zone") xlab(1/7) saving( `"${output}/zone_availability/`v'"' , replace) ylab(`yl')
		graphsout "${sp}/zone_availability/`v'", type(${graph}) replace 

		drop ml mls
	}
}
****************************End Program Availability****************************
****************************End Program Availability****************************
****************************End Program Availability****************************

******************************Program Composition*******************************
******************************Program Composition*******************************
******************************Program Composition*******************************
if $comp1 == 1 | $comp2 == 1 {
	use `"${final}/up_common_24"', clear	

	foreach v in $part2 {
		dis "`:var lab `v''"
		*!BF Note 12/10/2024: drop schools that don't have the program
		bys schoolname: egen tot_`v'=total(`v')
		replace `v'=. if tot_`v'<10
		fre `v'
	}
}
	
if $comp1 == 1 { //spreadsheets to match the figures (client request)
	foreach v in $part2 {
		tab grade `v', row
		gtab init cat col0 col1 col2
		gtab cat Participant Comparison: `:var lab `v''
		gtab col0 Student Non-Participants
		gtab col1 Student Participants
		gtab col2 N
		
		local vars female esl sped gifted frl r? `v'_std
		foreach var of varlist `vars' {
			sum `var' if !mi(`v')
			if `r(N)'>0 {
				gtab cat `:variable label `var''
				gtab col2 `r(N)'
			}
			levelsof `v' 
			foreach l in `r(levels)' {
				sum `var' if `v'==`l'
				if `r(N)'>0 {
					if `r(min)'>=0 & `r(max)'<=1 gtab col`l' `:di %3.0f  `=`r(mean)' * 100''% 
					*(`= string(`r(N)',"%9.0fc")')  //if dummy variable (imperfect, always double check)
					else gtab col`l' `:di %3.1f  `r(mean)'' 
					*(`= string(`r(N)',"%9.0fc")')
				}
			}
			gtab fill
		}
		gtab preview

		gtab export `"${output}/compare_participants/`v'.xlsx"', replace
		putexcel set `"${output}/compare_participants/`v'.xlsx"', modify
		local i=2
		foreach var of varlist `vars'{
			qui sum `var' if !mi(`v')
			if `r(N)'>0 {
				if `r(min)'>=0 & `r(max)'<=1 qui logit `var' `v' , vce(cl schoolid)
				qui reg `var' `v' , vce(cl schoolid)
				qui matlist r(table)
				matrix t = r(table)
				local pvalue=t[4,1] 
				if `pvalue'<.05 putexcel A`i':C`i', bold overwritefmt
				local ++i
			}
		}
		copy `"${output}/compare_participants/`v'.xlsx"' `"${sp}/compare_participants/`v'.xlsx"', replace
	}
}	
	
**Composition Figures** 
if $comp2 == 1 {
	gen overall = 1
	la var overall "Overall"
	la def o 1 "Overall"
	la val overall o 
	
	foreach part in $part2 {
		
		dis "Overall: `v'"
		dis ""
		fre `part'
		
		*build the graph datasets
		local vars female esl sped gifted frl race2 `part'_quart
		global title `:var lab `part''
		global irl=subinstr("`:var lab `part'_quart'", " (Quartiles)", "", 1)
		gtab init c0 c1 c2 c3 
		gtab c0 Var
		gtab c1 Cat
		gtab c2 Pos
		gtab c3 Part
		local p=1 
		foreach v of varlist `vars' {
			levelsof `v'
			foreach l in `r(levels)' {
				gtab c0 `v'
				gtab c1 `:lab (`v') `l''
				gtab c2 `p'
				qui sum `part' if `v'==`l'
				gtab c3 `=`r(mean)'*100'
				local ++p
			}
			local ++p
			*tab `v' `part', row
		}
		
		qui sum `part'
		global o `=`r(mean)'*100'

		*!BF Note 2/3/2025: save the quart label
		global qt `:var lab `part'_quart'

		preserve
		gtab import 
		autorename
		
		*drop variables with little variation
		foreach v in female esl sped gifted frl race2 `part'_quart {
			qui sum part if var=="`v'"
			if `r(max)'-`r(min)'<2 { //% difference between the highest and lowest value
				dis `"DROPPED: `v'"'
				qui sum pos if var=="`v'"
				replace pos=pos-(2+`r(max)'-`r(min)') if pos>`r(max)'
				drop if var=="`v'"
			}
		}
		
		*mlabels
		gen ml=round(part, 1)
		tostring ml, replace 
		replace ml=ml+"%"
			
		gen n=_n
		bys var (n): gen c=_n
		sort n
		
		*from BLIND: split out the score quartiles from everything else
		tempfile tf 
		save `tf'
		foreach j in 1 2 {
			use `tf', clear
			if `j'==1 {
				local if var!=`"`part'_quart"'
				local vn _demo
				local xt ""
			}
			if `j'==2 {
				local if var==`"`part'_quart"'
				local vn _iready	
				local xt xtitle(`"${qt}"')
			}
			
			qui count if `if'
			if `r(N)'==0 dis "did nothing"
			else {
				
				*xlabels
				local xl 
				levelsof n if `if'
				foreach i in `r(levels)' {
					local xl `xl' `=pos[`i']' `"`=cat[`i']'"'
				}	
				
				*y labels
				qui sum part if `if'
				local max 100 
				foreach m in 75 50 25 20 15 10 5 1 {
					if `r(max)'<=`m' local max `m'
				}
				local yl 
				forval i=0(`=`max'/5')`max' {
					local yl `yl' `i' "`i'%"
				}
		
				local tb 
				forval i=1/5 { //need as many colors as the largest number of groups
					local tb `tb' (bar part pos if c==`i' & `if' , bcolor("${c`i'}") mlab(ml) mlabcolor(black) mlabformat(%3.0f) mlabsize(3))
				}

				twoway `tb', title("") xtitle("") ytitle("Student Participation Rates for Each Group") ///
				ylab(`yl') xlab(`xl' , angle(45)) legend(off) yline( $o ) title(${title}) ///
				saving(`"${output}/compare_participants/`part'`vn'"', replace) `xt'
				graphsout "${sp}/compare_participants/`part'`vn'", type(${graph}) replace 
			}
		}
		restore
	}

}
****************************End Program Composition*****************************
****************************End Program Composition*****************************
****************************End Program Composition*****************************

********************************Change over Time********************************
********************************Change over Time********************************
********************************Change over Time********************************
if $change == 1 {
	
	use `"${final}/up_common_stu_lvl"', clear	
	*From BLIND: they want to use this definition of "elligable"
	foreach v in $part3 {
		dis "`:var lab `v''"
		*!BF Note 12/10/2024: drop schools that don't have the program
		bys schoolname year: egen tot_`v'=total(`v')
		dis `"`v'"'
		tab schoolname year if tot_`v'>0 & tot_`v'<10 & `v'==1 //what?!
		replace `v'=. if tot_`v'<10
	}
	
	// $part3 = those 8 participation dummy variables
	foreach v of varlist $part3 { //same variables twice
		gen pc_`v'=`v'
		la var pc_`v' `"`:var lab `v''"'
	}	
	foreach v of varlist _all { //save the labels
		local l`v' `:var lab `v''
	}	
	*mean for percents, sum for Ns
	collapse (mean) pc_* (sum) $part3 , by(year)
	foreach v of varlist _all { //re-apply labels
		la var `v' `"`l`v''"' 
	}	
		
	foreach v in $part3 { //the graphing loop
		
		replace pc_`v'=pc_`v'*100
		gen ml=round(pc_`v', .1)
		gen mls=string(ml)
		replace mls= mls + "%"
		
		*y axis for Ns
		sum `v'
		local max 50000 //if it stays 0, the gr command will give an error
		foreach m in 20000 10000 5000 2500 1000 500 100 25 { //possible max for y-labs
			if `r(max)'<=`m' local max `m'
		}
		local yln 
		forval i=0(`=`max'/5')`max' {
			local yln `yln' `i' `"`=string(`i', "%9.0fc")'"'
		}
		*y axis for %s
		sum pc_`v'
		local max 100 
		foreach m in 75 50 25 20 15 10 5 1 { //possible max for y-labs
			if `r(max)'<=`m' local max `m'
		}
		local ylp 
		forval i=0(`=`max'/5')`max' {
			local ylp `ylp' `i' "`i'%"
		}
		*x axis
		local xl 
		qui levelsof year if `v'>0
		foreach y in `r(levels)' {
			local xl `xl' `y' `"`=`y'-1'-`=`y'-2000'"'
		}	
/*
		*gr for Ns
		twoway connected `v' year if `v'>0, lcolor("${c1}") /*mlab(mls)*/ ytitle("Number of Participating Students") mcolor("${c1}") mlab(`v') mlabpos(12) mlabcolor(black) ylab(`yln') mlabformat(%9.0fc) xlab(`xl') saving( `"${output}/change_over_time/`v'"' , replace)
graphsout "${sp}/change_over_time/`v'", type(${graph}) replace 

		*gr for %s 
		twoway connected pc_`v' year if `v'>0, lcolor("${c1}") ytitle("Percent of Students Participating") mlab(mls) mcolor("${c1}") mlabpos(12) mlabcolor(black) ylab(`ylp') mlabformat(%9.0fc) xlab(`xl') saving( `"${output}/change_over_time/`v'_perc"' , replace)
		graphsout "${sp}/change_over_time/`v'_perc", type(${graph}) replace 
*/
		*gr with both, two options for label positions
		twoway (connected `v' year if `v'>0, lcolor("${c1}") /*mlab(mls)*/ mcolor("${c1}") mlab(`v') mlabpos(6) mlabcolor(black) mlabformat(%9.0fc) xlab(`xl')) (connected pc_`v' year if `v'>0, lcolor("${c2}") mlab(mls) mcolor("${c2}") mlabpos(12) mlabcolor(black) mlabformat(%9.0fc) yaxis(2)) , ytitle("Number of Participating Students", axis(1)) ylab(`yln', axis(1)) ytitle("Percent of Students Participating", axis(2)) ylab(`ylp', axis(2)) saving( `"${output}/change_over_time/`v'_2yl"' , replace) legend(off) title(`:var lab `v'')
		graphsout "${sp}/change_over_time/`v'_2y1", type(${graph}) replace 

		twoway (connected `v' year if `v'>0, lcolor("${c1}") /*mlab(mls)*/ mcolor("${c1}") mlab(`v') mlabpos(12) mlabcolor(black) mlabformat(%9.0fc) xlab(`xl')) (connected pc_`v' year if `v'>0, lcolor("${c2}") mlab(mls) mcolor("${c2}") mlabpos(6) mlabcolor(black) mlabformat(%9.0fc) yaxis(2)) , ytitle("Number of Participating Students", axis(1)) ylab(`yln', axis(1)) ytitle("Percent of Students Participating", axis(2)) ylab(`ylp', axis(2)) saving( `"${output}/change_over_time/`v'_2y2"' , replace) legend(off) title(`:var lab `v'')
		graphsout "${sp}/change_over_time/`v'_2y2", type(${graph}) replace 
		drop ml mls
	}

}
******************************End Change over Time******************************
******************************End Change over Time******************************
******************************End Change over Time******************************


log close 
stop
